/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	SeparatorLine.cpp
	
	Contains:	Implementation of a groovy separator line BView
				subclass.
	
	   Notes:	None.
	   
   ............................................................... */

#ifndef _SEPARATOR_LINE_H
#include "SeparatorLine.h"
#endif

/* ...............................................................
	SeparatorLine Constructor
	Resizes the separator line correctly.
   ............................................................... */

SeparatorLine::SeparatorLine(BRect frame, const char *name, orientation
							 kind, uint32 resizeMask, uint32 flags)
			  :BView(frame, name, resizeMask, flags),
			   _kind(kind)
{
	if (kind == B_HORIZONTAL)
		ResizeTo(frame.Width(), 2);
	else
		ResizeTo(2, frame.Height());
	SetViewColor(RGB_COLOR_216);
}


/* ...............................................................
	SeparatorLine::Draw()
	Draws the separator line.
   ............................................................... */

void SeparatorLine::Draw(BRect updateRect)
{
#pragma unused(updateRect)
	BRect		bounds = Bounds();
	
	/* Draw in a line array for speed */
	BeginLineArray(5);
	AddLine(BPoint(bounds.left, bounds.top), 
			BPoint(bounds.right - 1, bounds.top), 
			RGB_COLOR_152);
	AddLine(BPoint(bounds.left, bounds.top + 1), 
			BPoint(bounds.left, bounds.bottom), 
			RGB_COLOR_152);
	AddLine(BPoint(bounds.right, bounds.top), 
			BPoint(bounds.right, bounds.bottom), 
			RGB_COLOR_235);
	AddLine(BPoint(bounds.right - 1, bounds.bottom), 
			BPoint(bounds.left + 1, bounds.bottom), 
			RGB_COLOR_235);
	AddLine(BPoint(bounds.left + 1, bounds.top + 1), 
			BPoint(bounds.right - 1, bounds.top + 1), 
			WHITE_COLOR);
	EndLineArray();
}